VERSION 5.00
Begin VB.Form frmImage 
   Caption         =   "paintPictureBox"
   ClientHeight    =   6015
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   5250
   LinkTopic       =   "Form1"
   ScaleHeight     =   401
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   350
   StartUpPosition =   3  'Windows Default
   Begin VB.ComboBox Combo1 
      Height          =   315
      Left            =   4500
      TabIndex        =   8
      Text            =   "Combo1"
      Top             =   5640
      Width           =   675
   End
   Begin VB.OptionButton optLinear 
      Caption         =   "Linear"
      Height          =   255
      Left            =   2040
      TabIndex        =   7
      Top             =   5700
      Value           =   -1  'True
      Width           =   855
   End
   Begin VB.OptionButton optRadial 
      Caption         =   "Radial"
      Height          =   255
      Left            =   3000
      TabIndex        =   6
      Top             =   5700
      Width           =   855
   End
   Begin VB.Timer Timer1 
      Enabled         =   0   'False
      Interval        =   200
      Left            =   0
      Top             =   0
   End
   Begin VB.PictureBox pctDot 
      Appearance      =   0  'Flat
      BackColor       =   &H00FF0000&
      ForeColor       =   &H80000008&
      Height          =   135
      Index           =   1
      Left            =   5040
      ScaleHeight     =   7
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   7
      TabIndex        =   4
      Top             =   2400
      Width           =   135
   End
   Begin VB.PictureBox pctDot 
      Appearance      =   0  'Flat
      BackColor       =   &H000000FF&
      ForeColor       =   &H80000008&
      Height          =   135
      Index           =   0
      Left            =   60
      ScaleHeight     =   7
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   7
      TabIndex        =   3
      Top             =   2400
      Width           =   135
   End
   Begin VB.CommandButton cmdCancel 
      Cancel          =   -1  'True
      Caption         =   "Cancel"
      Enabled         =   0   'False
      Height          =   495
      Left            =   60
      TabIndex        =   2
      Top             =   5400
      Width           =   855
   End
   Begin VB.CommandButton cmdDone 
      Caption         =   "Done"
      Default         =   -1  'True
      Enabled         =   0   'False
      Height          =   495
      Left            =   1080
      TabIndex        =   1
      Top             =   5400
      Width           =   855
   End
   Begin VB.PictureBox Picture1 
      Appearance      =   0  'Flat
      AutoRedraw      =   -1  'True
      BackColor       =   &H80000005&
      BorderStyle     =   0  'None
      ForeColor       =   &H80000008&
      Height          =   5100
      Left            =   60
      ScaleHeight     =   340
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   340
      TabIndex        =   0
      Top             =   60
      Visible         =   0   'False
      Width           =   5100
   End
   Begin VB.Label lblSize 
      Alignment       =   1  'Right Justify
      Caption         =   "Size"
      Height          =   195
      Left            =   3900
      TabIndex        =   9
      Top             =   5700
      Width           =   495
   End
   Begin VB.Label lblMsg 
      Caption         =   "Please wait, scanning image...."
      Height          =   315
      Left            =   2100
      TabIndex        =   5
      Top             =   5400
      Width           =   3015
   End
End
Attribute VB_Name = "frmImage"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Public originX
Public originY
Public myAngle

Private Sub cmdCancel_Click()
    frmImage.Picture1.Visible = False
    Unload frmImage
End Sub

Private Sub cmdDone_Click()
    errMsg = "Done button on frmImage."
    On Error GoTo errHandler
    If frmImage.optLinear Then
        frmUI.optLinear.Value = True
        frmUI.txtAngle = CStr(Round(myAngle))
    Else
        frmUI.optRadial.Value = True
        frmUI.txtX = Round(originX)
        frmUI.txtY = Round(originY)
    End If
    frmUI.setEnableds
    frmImage.Picture1.Visible = False
    Unload Me
    Exit Sub
errHandler:
    MsgBox "Error #" & Err.Number & ": " & Err.Description & vbCrLf & "Context: " & errMsg
    Exit Sub
End Sub

Private Sub Combo1_Click()
    If pointIndex = -1 Then Exit Sub
    errMsg = "Setting Preview scale to " & frmImage.Combo1.ListIndex + 1
    previewScale = CInt(frmImage.Combo1.ListIndex + 1)
    ' save it to registry.
    If previewScale < 1 Then previewScale = 1
    SaveSetting "NewAstro Gradient Removal", "resume", "previewScale", CStr(previewScale)
    paintPictureBox
End Sub

Private Sub Form_Load()
    errMsg = "Loading frmImage."
    'On Error GoTo errHandler
    frmImage.pctDot(0).Visible = False
    frmImage.pctDot(1).Visible = False
    pointIndex = -1
    frmImage.Combo1.AddItem "1:1"
    frmImage.Combo1.AddItem "1:2"
    frmImage.Combo1.AddItem "1:3"
    frmImage.Combo1.AddItem "1:4"
    frmImage.Combo1.AddItem "1:5"
    frmImage.Combo1.AddItem "1:6"
    If previewScale < 1 Then previewScale = 1
    frmImage.Combo1.ListIndex = previewScale - 1
    pointIndex = 0
    Timer1.Enabled = True
    Exit Sub
errHandler:
    MsgBox "Error #" & Err.Number & ": " & Err.Description & vbCrLf & "Context: " & errMsg
    Exit Sub
End Sub

Private Sub Form_Unload(Cancel As Integer)
    frmImage.Picture1.Visible = False
End Sub

Private Sub optLinear_Click()
    frmImage.pctDot(1).Visible = True
    calculateAngle
End Sub

Private Sub optRadial_Click()
    frmImage.pctDot(1).Visible = False
    calculateOrigin
End Sub

Private Sub Picture1_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
   
    'If altitude < 0 Or altitude > 90 Or azimuth < 0 Or azimuth > 360 Then
    '    Label1.Caption = "Outside boundaries"
    '    Exit Sub
    'End If
    On Error GoTo errHandler
    If Button = 2 Then
        pointIndex = 1
    Else
        If Button = 1 Then
            pointIndex = 0
        End If
    End If
    frmImage.pctDot(pointIndex).ZOrder
    frmImage.pctDot(pointIndex).Left = X '- (frmImage.pctDot(pointIndex).ScaleWidth / 4)
    frmImage.pctDot(pointIndex).Top = Y '- (frmImage.pctDot(pointIndex).ScaleHeight / 4)
    If pointIndex = 0 Or optLinear Then
        frmImage.pctDot(pointIndex).Visible = True
    End If
    If frmImage.optLinear Then
        calculateAngle
    Else
        calculateOrigin
    End If
    Exit Sub
errHandler:
    MsgBox "Error #" & Err.Number & ": " & Err.Description & vbCrLf & "Context: " & errMsg
    Exit Sub
End Sub

Sub calculateAngle()
    errMsg = "CalculateAngle()"
    On Error GoTo errHandler
    X = frmImage.pctDot(1).Left - frmImage.pctDot(0).Left
    Y = frmImage.pctDot(1).Top - frmImage.pctDot(0).Top
    If Y = 0 Then Y = 0.000000001
    If Y < 0 And X > 0 Then
        myAngle = (Atn(Abs(X / Y)) * 57.2957795130823) + 270
    Else
        If Y > 0 And X < 0 Then
            myAngle = (Atn(Abs(X / Y)) * 57.2957795130823) + 90
        Else
            If Y > 0 And X > 0 Then
                myAngle = 90 - (Atn(Abs(X / Y)) * 57.2957795130823)
            Else
                myAngle = 90 - (Atn(Abs(X / Y)) * 57.2957795130823) + 180
            End If
        End If
    End If
    If myAngle < 0 Then myAngle = 0
    If myAngle > 359 Then myAngle = 359
    frmImage.lblMsg = "Angle: " & CStr(Round(myAngle))
    Exit Sub
errHandler:
    MsgBox "Error #" & Err.Number & ": " & Err.Description & vbCrLf & "Context: " & errMsg
    Exit Sub
End Sub

Sub calculateOrigin()
    errMsg = "CalculateOrigin()"
    On Error GoTo errHandler
    originX = (frmImage.pctDot(0).Left) * previewScale
    If originX > imgWidth Then originX = imageWidth
    If originX < 0 Then originX = 0
    originY = (frmImage.pctDot(0).Top) * previewScale
    If originY > imgHeight Then originY = imgHeight
    If originY < 0 Then originY = 0
    frmImage.lblMsg = "Origin: " & CStr(Round(originX)) & ", " & CStr(Round(originY))
    Exit Sub
errHandler:
    MsgBox "Error #" & Err.Number & ": " & Err.Description & vbCrLf & "Context: " & errMsg
    Exit Sub
End Sub

Sub drawLines()
    On Error GoTo errHandler
    errMsg = "drawLines()"
    SX = frmImage.pctDot(1).Left + (frmImage.pctDot(1).Width / 2)
    SY = frmImage.pctDot(1).Top + (frmImage.pctDot(1).Height / 2)
    EX = frmImage.pctDot(2).Left + (frmImage.pctDot(2).Width / 2)
    EY = frmImage.pctDot(2).Top + (frmImage.pctDot(2).Height / 2)
    frmImage.Picture1.Line (SX, SY)-(EX, EY), RGB(255, 0, 0)
    On Error GoTo 0
    Exit Sub
    
errHandler:
    MsgBox "Error drawing lines." & vbCrLf & Err.Number & ": " & Err.Description
    Exit Sub
End Sub


Sub eraseLines()
    FillStyle = 0
    frmImage.Picture1.Line (0, 0)-Step(12000, 12000), RGB(212, 212, 212), BF
End Sub

Private Sub Picture1_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
    Dim myTotal, myCount, Neighborhood(49)
    
    'On Error GoTo errHandler
    ' if Picture1 has not yet been scaled to image size, exit.
    If Not frmImage.Picture1.Visible Then Exit Sub
    myTotal = 0
    myCount = 0
    For i = -3 To 3 Step 1
        For j = -3 To 3 Step 1
            If X * previewScale + i > 0 And Y * previewScale + j > 0 And X > 0 And Y > 0 And X * previewScale + i < imgWidth - 1 And Y * previewScale + j < imgHeight - 1 Then
                Neighborhood(myCount) = myImgArray(X * previewScale + i, Y * previewScale + j)
                myTotal = myTotal + myImgArray(X * previewScale + i, Y * previewScale + j)
                myCount = myCount + 1
            End If
        Next j
    Next i
    If myCount > 4 Then
        myAVG = Round(myTotal / myCount, 1)
        QSort Neighborhood, 0, myCount
        myMEDIAN = Neighborhood(Round(myCount / 2))
        lblMsg.Caption = "Avg: " & myAVG & "  Med: " & myMEDIAN
    End If
    Exit Sub
errHandler:
    MsgBox "Error #" & Err.Number & ": " & Err.Description & vbCrLf & "Context: " & errMsg
    Exit Sub
End Sub

Private Sub Timer1_Timer()
    Timer1.Enabled = False
    errMsg = "Timer1"
    On Error GoTo errHandler
    paintPictureBox
    errMsg = "Set visibility of dots."
    If frmImage.optLinear Then
        errMsg = "Show pctDot(0) - Linear"
        frmImage.pctDot(0).Visible = True
        errMsg = "Show pctDot(1) - Linear"
        frmImage.pctDot(1).Visible = True
        frmImage.lblMsg = "Left click bright/right click dim."
    Else
        errMsg = "Show pctDot(0) - Radial"
        frmImage.pctDot(0).Visible = True
        errMsg = "Hide pctDot(1) - Radial"
        frmImage.pctDot(1).Visible = False
        frmImage.lblMsg = "Left click to set center of radial gradient."
    End If
    Exit Sub
errHandler:
    MsgBox "Error #" & Err.Number & ": " & Err.Description & vbCrLf & "Context: " & errMsg
    Exit Sub
End Sub
