Attribute VB_Name = "Module1"
Public isMaxIm As Boolean
'Public myImgArray() As Single, myOrigArray() As Single, myTempArray() As Single
Public myImgArray, myOrigArray, myTempArray
Public saveOK
Public imgHeight
Public imgWidth
Public myDoc As Object
Public Img As Object
Public RegistryKeyName
Public registeredUser
Public pointIndex
Public previewScale As Integer
Public isColor
Public errMsg
Public abortPaintImage As Boolean

' Public Img As CCDSoftLib.Image

Private Const SW_HIDE = 0
Private Const SW_SHOWNORMAL = 1
Private Const SW_SHOWMINIMIZED = 2
Private Const SW_SHOWMAXIMIZED = 3

Private Declare Function ShellExecute Lib "shell32" Alias "ShellExecuteA" ( _
                ByVal hWnd As Long, _
                ByVal lpOperation As String, _
                ByVal lpFile As String, _
                ByVal lpParameters As String, _
                ByVal lpDirectory As String, _
                ByVal nShowCmd As Long) As Long

Public Sub MaxImSave()
    On Error GoTo errHandler
    errMsg = "MaxImSave()"
    Dim myDocBogus
    If saveOK Then
        myDocBogus = myDoc.DirectMono
        myDoc.ImageArray = myImgArray
        myDoc.Modified = True
        frmUI.lblStatus = "Save changes (MaxIm DL)...saved"
    Else
        frmUI.lblStatus = "Changes not saved."
    End If
    Exit Sub
errHandler:
    MsgBox "Error #" & Err.Number & ": " & Err.Description & vbCrLf & "Context: " & errMsg
    Exit Sub
End Sub

Public Sub CCDSoftSave()
    On Error GoTo errHandler
    errMsg = "CCDSoftSave()"
    If saveOK Then
        Img.DataArray = myImgArray
        Img.ModifiedFlag = True
        frmUI.lblStatus = "Save changes (CCDSoft)...saved"
    Else
        frmUI.lblStatus = "Changes not saved."
    End If
    Exit Sub
errHandler:
    MsgBox "Error #" & Err.Number & ": " & Err.Description & vbCrLf & "Context: " & errMsg
    Exit Sub
End Sub

Public Sub remGradient()
    Dim Data As Variant
    Dim X, Y
    Dim gradH, gradV, gradAngle
    Dim myWidth, myHeight, newValue
    
    ' Save starting state in an array.
    myTempArray = myImgArray
    
    frmUI.lblStatus = "Removing gradient..."
    DoEvents
    
    On Error GoTo errHandler
    errMsg = "Getting data from dialog."
    ' Get gradient value.
    gradH = Round(CDbl(frmUI.txtHorizontal.Text))
    ' Get gradient angle.
    gradAngle = CDbl(frmUI.txtAngle.Text)
    
    If gradAngle <= 90 Then
        frmUI.chkFlipH.Value = 0
        frmUI.chkFlipV.Value = 0
    Else
        If gradAngle <= 180 Then
            frmUI.chkFlipH.Value = 1
            frmUI.chkFlipV.Value = 0
            gradAngle = 90 - (gradAngle Mod 90)
        Else
            If gradAngle <= 270 Then
                frmUI.chkFlipH.Value = 1
                frmUI.chkFlipV.Value = 1
                gradAngle = gradAngle Mod 90
            Else
                If gradAngle <= 359.9 Then
                    frmUI.chkFlipH.Value = 0
                    frmUI.chkFlipV.Value = 1
                    gradAngle = 90 - (gradAngle Mod 90)
                Else
                    MsgBox "Invalid gradient angle: " & gradAngle
                    Exit Sub
                End If
            End If
        End If
    End If
    
    ' Determine if gradient is horizontal, or not.
    errMsg = "Determining angle of gradient."
    If gradAngle <> 0 Then
        gradV = (gradH * (imgHeight / imgWidth)) * (gradAngle / 45)
    Else
        gradV = 0
    End If
    
    Randomize
    
    If frmUI.chkDoAll.Value = 1 Then
        If isMaxIm Then
            Set TheApp = New Maxim.Application
            Set AllDocs = TheApp.Documents
            numImages = AllDocs.Count
        Else
            ' Not implemented. Will use folder object.
            numImages = 1
        End If
    Else
        numImages = 1
    End If
For z = 1 To numImages
    If frmUI.chkDoAll.Value = 1 Then
        If isMaxIm Then
            Set myDoc = AllDocs(z)
            myImgArray = myDoc.ImageArray
        Else
            ' Not implemented. Will use folder object.
        End If
    End If

    ' Remove the gradient.
    myWidth = imgWidth - 1
    myHeight = imgHeight - 1
    If Not frmUI.optRadial.Value Then
        ' Remove linear gradient.
        errMsg = "Removing radial gradient."
        myIntensity = CDbl(frmUI.txtIntensity.Text)
        cosCriticalAngle = imgHeight / Sqr(imgHeight ^ 2 + imgWidth ^ 2)
        cosGradAngle = Cos(gradAngle / 57.295779)
        If cosGradAngle < cosCriticalAngle Then
            ' Vertical Gradient
            theta = (90 - gradAngle) / 57.295779
            test1 = imgHeight / Cos(theta)
            test2 = imgHeight * Tan(theta)
            test3 = (imgWidth - (imgHeight * Tan(theta))) * Sin(theta)
            greatestDistance = (imgHeight / Cos(theta)) + ((imgWidth - (imgHeight * Tan(theta))) * Sin(theta))
        Else
            ' Horizontal Gradient
            theta = (gradAngle) / 57.295779
            test1 = imgWidth / Cos(theta)
            test2 = imgWidth * Tan(theta)
            test3 = (imgHeight - (imgWidth * Tan(theta))) * Sin(theta)
            greatestDistance = (imgWidth / Cos(theta)) + ((imgHeight - (imgWidth * Tan(theta))) * Sin(theta))
        End If
        For Y = 0 To myHeight
            If Y Mod 10 = 0 Then frmUI.lblStatus = "Row " & Y & " of " & myHeight & "..."
            DoEvents
            errMsg = "Processing radial gradient, row " & Y
            For X = 0 To myWidth
                If frmUI.chkFlipV.Value = 0 Then
                    If frmUI.chkFlipH.Value = 0 Then
                        If Cos(gradAngle) < cosCriticalAngle Then
                        ' Vertical Gradient
                            theta = gradAngle / 57.295779
                            thisDistance = ((Y - (X * Tan(theta))) * Sin(theta)) + X / Cos(theta)
                        Else
                            ' Horizontal Gradient
                            theta = (90 - gradAngle) / 57.295779
                            thisDistance = ((X - (Y * Tan(theta))) * Sin(theta)) + Y / Cos(theta)
                        End If
                    Else
                        If Cos(gradAngle) > cosCriticalAngle Then
                        ' Vertical Gradient
                            theta = gradAngle / 57.295779
                            thisDistance = (((Y) - ((imgWidth - X) * Tan(theta))) * Sin(theta)) + imgWidth - X / Cos(theta)
                        Else
                            ' Horizontal Gradient
                            theta = (90 - gradAngle) / 57.295779
                            thisDistance = (((imgWidth - X) - ((Y) * Tan(theta))) * Sin(theta)) + (Y) / Cos(theta)
                        End If
                    End If
                Else
                    If frmUI.chkFlipH.Value = 1 Then
                        If Cos(gradAngle) < cosCriticalAngle Then
                        ' Vertical Gradient
                            theta = gradAngle / 57.295779
                            thisDistance = ((Y - (X * Tan(theta))) * Sin(theta)) + X / Cos(theta)
                        Else
                            ' Horizontal Gradient
                            theta = (90 - gradAngle) / 57.295779
                            thisDistance = ((X - (Y * Tan(theta))) * Sin(theta)) + Y / Cos(theta)
                        End If
                    Else
                        If Cos(gradAngle) > cosCriticalAngle Then
                        ' Vertical Gradient
                            theta = gradAngle / 57.295779
                            thisDistance = (((Y) - ((imgWidth - X) * Tan(theta))) * Sin(theta)) + imgWidth - X / Cos(theta)
                        Else
                            ' Horizontal Gradient
                            theta = (90 - gradAngle) / 57.295779
                            thisDistance = (((imgWidth - X) - ((Y) * Tan(theta))) * Sin(theta)) + (Y) / Cos(theta)
                        End If
                    End If
                End If
                
                myVary = Int(4 * Rnd) - 2
                If thisDistance < 0 Then thisDistance = 0
                If Y > 1 Then
                    'rw1 = thisDistance ^ myIntensity
                    'rw2 = greatestDistance ^ myIntensity
                    myProportion = (thisDistance ^ myIntensity / greatestDistance ^ myIntensity)
                Else
                    myProportion = 0
                End If

                If frmUI.chkFlipV.Value = 0 Then
                    If frmUI.chkReverse.Value = 1 Then
                        newValue = myImgArray(X, Y) + (gradH * (1 - myProportion)) + myVary
                    Else
                        newValue = myImgArray(X, Y) - (gradH * (1 - myProportion)) + myVary
                    End If
                    If newValue < 0 Then
                        newValue = 0
                    End If
                Else
                    ' Flip vertically.
                    If frmUI.chkReverse.Value = 1 Then
                        newValue = myImgArray(X, Y) + (gradH * myProportion) + myVary
                        If newValue > 65535 Then
                            newValue = 65535
                        End If
                    Else
                        newValue = myImgArray(X, Y) - (gradH * myProportion) + myVary
                        If newValue < 0 Then
                            newValue = 0
                        End If
                    End If
                End If
                myImgArray(X, Y) = newValue
            Next X
        Next Y
    Else
        ' Remove radial gradient.
        ' Find largest distance to a corner.
        errMsg = "Removing radial gradient."
        originX = CDbl(frmUI.txtX.Text)
        originY = CDbl(frmUI.txtY.Text)
        centralAperture = CDbl(frmUI.txtIntensity.Text)
        errMsg = "Finding origin coordinates."
        If originX < myWidth / 2 Then
            ' Left of center.
            If originY < myHeight / 2 Then
                ' Above center. Calculate greatest distance to lower right corner.
                xDistance = myWidth - originX
                yDistance = myHeight - originY
            Else
                ' Below center. Calculate greatest distance to upper right corner.
                xDistance = myWidth - originX
                yDistance = originY
            End If
        Else
            ' Right of center.
            If originY < myHeight / 2 Then
                ' Above center. Calculate greatest distance to lower left corner.
                xDistance = originX
                yDistance = myHeight - originY
            Else
                ' Below center. Calculate greatest distance to upper left corner.
                xDistance = originX
                yDistance = originY
            End If
        End If
        errMsg = "Finding corner furthest from origin."
        greatestDistance = Sqr((xDistance) ^ 2 + (yDistance) ^ 2)
        
        For Y = 0 To myHeight
            If Y Mod 10 = 0 Then frmUI.lblStatus = "Row " & Y & " of " & myHeight & "..."
            DoEvents
            errMsg = "Processing linear gradient, row " & Y
            For X = 0 To myWidth
                myVary = Int(4 * Rnd) - 2
                ' Calculate distance from origin.
                xDistance = Abs(originX - X)
                yDistance = Abs(originY - Y)
                thisDistance = Sqr(xDistance ^ 2 + yDistance ^ 2) '- protectedRadius
                If thisDistance > 1 Then
                    myProportion = 1 - (thisDistance ^ centralAperture / greatestDistance ^ centralAperture)
                Else
                    myProportion = 1
                End If
                If frmUI.chkReverse.Value = 1 Then
                    newValue = myImgArray(X, Y) + (gradH * myProportion) + myVary
                    If newValue > 65535 Then
                        newValue = 65535
                    End If
                Else
                    newValue = myImgArray(X, Y) - (gradH * myProportion) + myVary
                    If newValue < 0 Then
                        newValue = 0
                    End If
                End If
                myImgArray(X, Y) = newValue
            Next X
        Next Y
    End If
    saveOK = True
    errMsg = "Saving results."
    If isMaxIm Then
        errMsg = "Saving results in MaxIm DL."
        frmUI.lblStatus = "Save changes (MaxIm DL)"
        DoEvents
        MaxImSave
    Else
        errMsg = "Saving results in CCDSoft."
        frmUI.lblStatus = "Save changes (CCDSoft)"
        DoEvents
        CCDSoftSave
    End If
Next z
If frmUI.chkDoAll.Value = 1 Then
    Set TheApp = Nothing
    Set AllDocs = Nothing
End If

    On Error GoTo 0
    Exit Sub

' Report any errors.
errHandler:
    MsgBox "Error #" & Err.Number & " - " & Err.Description & vbCrLf & "Additional information: " & errMsg
    Exit Sub
End Sub

Public Sub ShowWebpage(path As String)
    Dim z As Long

    z = ShellExecute(0, "Open", path, 0, 0, SW_SHOWNORMAL)
    If (z > 0) And (z <= 32) Then
        MsgBox _
            "It doesn't appear that you have a web browser installed " & _
            "on your system.", (vbOKOnly + vbExclamation + vbMsgBoxSetForeground), "NewAstro Remove Gradient Plug-In"
        Exit Sub
    End If

End Sub

Public Sub saveRegSettings()
    On Error GoTo errHandler
    errMsg = "saveRegSettings()"
    SaveSetting "NewAstro Gradient Removal", "resume", "txtIntensity", frmUI.txtIntensity.Text
    SaveSetting "NewAstro Gradient Removal", "resume", "txtX", frmUI.txtX.Text
    SaveSetting "NewAstro Gradient Removal", "resume", "txtY", frmUI.txtY.Text
    SaveSetting "NewAstro Gradient Removal", "resume", "txtHorizontal", frmUI.txtHorizontal.Text
    SaveSetting "NewAstro Gradient Removal", "resume", "txtAngle", frmUI.txtAngle.Text
    SaveSetting "NewAstro Gradient Removal", "resume", "optLinear", frmUI.optLinear
    SaveSetting "NewAstro Gradient Removal", "resume", "optRadial", frmUI.optRadial
    SaveSetting "NewAstro Gradient Removal", "resume", "txtSigma", frmUI.txtSigma.Text
    SaveSetting "NewAstro Gradient Removal", "resume", "txtStrength", frmUI.txtStrength.Text
    SaveSetting "NewAstro Gradient Removal", "resume", "top", frmUI.Top
    SaveSetting "NewAstro Gradient Removal", "resume", "left", frmUI.Left
    SaveSetting "NewAstro Gradient Removal", "resume", "chkDoAll", frmUI.chkDoAll.Value
    If previewScale < 1 Then previewScale = 1
    SaveSetting "NewAstro Gradient Removal", "resume", "previewScale", previewScale
    Exit Sub
errHandler:
    MsgBox "Error #" & Err.Number & ": " & Err.Description & vbCrLf & "Context: " & errMsg
    Exit Sub
End Sub

Public Sub getRegSettings()
    Dim myPreviewScale
    
    On Error GoTo errHandler
    errMsg = "getRegSettings()"
    frmUI.txtIntensity.Text = GetSetting("NewAstro Gradient Removal", "resume", "txtIntensity", "1")
    errMsg = "txtX"
    frmUI.txtX.Text = GetSetting("NewAstro Gradient Removal", "resume", "txtX", "0")
    errMsg = "txtY"
    frmUI.txtY.Text = GetSetting("NewAstro Gradient Removal", "resume", "txtY", "0")
    errMsg = "txtHorizontal"
    frmUI.txtHorizontal.Text = GetSetting("NewAstro Gradient Removal", "resume", "txtHorizontal", "100")
    errMsg = "txtAngle"
    frmUI.txtAngle.Text = GetSetting("NewAstro Gradient Removal", "resume", "txtAngle", "0")
    errMsg = "optLinear"
    frmUI.optLinear = GetSetting("NewAstro Gradient Removal", "resume", "optLinear", "True")
    errMsg = "optRadial"
    frmUI.optRadial = GetSetting("NewAstro Gradient Removal", "resume", "optRadial", "False")
    errMsg = "txtSigma"
    frmUI.txtSigma.Text = GetSetting("NewAstro Gradient Removal", "resume", "txtSigma", "2.4")
    errMsg = "txtStrength"
    frmUI.txtStrength.Text = GetSetting("NewAstro Gradient Removal", "resume", "txtStrength", "1000")
    errMsg = "top"
    frmUI.Top = GetSetting("NewAstro Gradient Removal", "resume", "top", "100")
    errMsg = "left"
    frmUI.Left = GetSetting("NewAstro Gradient Removal", "resume", "left", "100")
    errMsg = "chkDoAll"
    frmUI.chkDoAll.Value = GetSetting("NewAstro Gradient Removal", "resume", "chkDoAll", "1")
    errMsg = "previewScale"
    myPreviewScale = CStr(GetSetting("NewAstro Gradient Removal", "resume", "previewScale", "4"))
    errMsg = "Check limit on preview scale (" & previewScale & ")."
    If IsNumeric(myPreviewScale) Then
        errMsg = "Valid previewScale."
        If CInt(myPreviewScale) < 1 Then myPreviewScale = "1"
        previewScale = CInt(myPreviewScale)
    Else
        errMsg = "Invalid previewScale; set to 4."
        previewScale = 4
    End If
    Exit Sub
errHandler:
    MsgBox "Error #" & Err.Number & ": " & Err.Description & vbCrLf & "Context: " & errMsg
    Exit Sub
End Sub

Public Sub cleanImage(intensity, spread)
    Dim Xmax, Ymax, i, j, X, Y, k
    Dim sigma, sigs
    Dim Neighborhood(9)
    Dim myTotal, myAVG, kk, l
    Dim msgPrefix
    
    On Error GoTo errHandler
    errMsg = "cleanImage(intensity=" & intensity & ", spread=" & spread & ")"
    ' Save starting state in an array.
    myTempArray = myImgArray
    
    If frmUI.chkDoAll.Value = 1 Then
        If isMaxIm Then
            Set TheApp = New Maxim.Application
            Set AllDocs = TheApp.Documents
            numImages = AllDocs.Count
        Else
            ' Not implemented. Will use folder object.
            numImages = 1
        End If
    Else
        numImages = 1
    End If
For z = 1 To numImages
    If frmUI.chkDoAll.Value = 1 Then
        If isMaxIm Then
            Set myDoc = AllDocs(z)
            myImgArray = myDoc.ImageArray
            msgPrefix = "# " & z & ": "
        Else
            ' Not implemented. Will use folder object.
            msgPrefix = ""
        End If
    End If
    frmUI.lblStatus = "Setting up to despeckle..."
    DoEvents
    
    errMsg = "Calculating average background value."
    Xmax = imgWidth - 1
    Ymax = imgHeight - 1
    errMsg = "Getting data from image."
    'myImgArray = Img.DataArray
    myTotal = 0
    k = 0
    errMsg = "Entering for 'y' loop for calculating average background value. Max: " & Ymax
    For Y = 1 To Ymax - 1
        DoEvents
        If Y Mod 10 = 0 Then
        errMsg = "Sampling on the Y axis at " & Y
        For X = 1 To Xmax - 1
            errMsg = "Entering for 'x' loop for calculating average background value. Max: " & Xmax
            If X Mod 10 = 0 Then
                errMsg = "Sampling on the X axis at " & X & ". myTotal: " & myTotal & "; current pixel: " & myImgArray(X, Y)
                myTotal = myTotal + myImgArray(X, Y)
                k = k + 1
            End If
            DoEvents
        Next X
        End If
    Next Y
    myAVG = myTotal / k
    kk = 0
    
    errMsg = "Despeckling functional code."
    frmUI.lblStatus = "Despeckling..."
    DoEvents
    For Y = 1 To Ymax - 1
        DoEvents
        If Y Mod 10 = 0 Then
            frmUI.lblStatus = msgPrefix & "Row " & Y & "..."
            DoEvents
        End If
        For X = 1 To Xmax - 1
            k = 0
            If myImgArray(X, Y) > myAVG + spread Or myImgArray(X, Y) < myAVG - spread Then
            For i = -1 To 1
                For j = -1 To 1
                    Neighborhood(k) = myImgArray(X + i, Y + j)
                    k = k + 1
                    kk = kk + 1
                Next j
            Next i
            QSort Neighborhood, 0, 8
            sigma = (Neighborhood(7) - Neighborhood(1)) / 2
            If myImgArray(X, Y) > Neighborhood(4) + intensity * sigma Then
                myImgArray(X, Y) = Neighborhood(4)
            End If
            If myImgArray(X, Y) < Neighborhood(4) - intensity * sigma Then
                myImgArray(X, Y) = Neighborhood(4)
            End If
            Else
                l = l + 1
            End If
            DoEvents
        Next X
    Next Y
    errMsg = "Saving changes back to image."
    saveOK = True
    errMsg = "Saving results."
    If isMaxIm Then
        errMsg = "Saving results in MaxIm DL."
        frmUI.lblStatus = "Save changes (MaxIm DL)"
        DoEvents
        MaxImSave
    Else
        errMsg = "Saving results in CCDSoft."
        frmUI.lblStatus = "Save changes (CCDSoft)"
        DoEvents
        CCDSoftSave
    End If
Next z
If frmUI.chkDoAll.Value = 1 Then
    Set TheApp = Nothing
    Set AllDocs = Nothing
End If
    Exit Sub
errHandler:
    MsgBox "Error #" & Err.Number & ": " & Err.Description & vbCrLf & "Context: " & errMsg
    Exit Sub
End Sub

Public Sub paintPictureBox()
    Dim l, m, n, X, CX, CY, Msg, XPos, YPos   ' Declare variables.
    Dim myMin, myScale
    Dim i As Integer
    Dim j As Integer
    Dim W As Integer
    Dim H As Integer

    i = Screen.TwipsPerPixelX
    j = Screen.TwipsPerPixelY
    W = Screen.Width / i
    H = Screen.Height / j
    errMsg = "paintPictureBox()"
    On Error GoTo errHandler
    'On Error GoTo 0
    If pointIndex = -1 Then
        Exit Sub
    End If
    frmImage.Caption = "Loading image..."
    frmImage.lblMsg.Caption = "Loading image..."
    DoEvents
    If isMaxIm Then
        myMin = myDoc.StretchMin
        If myMin < 0 Then myMin = 0
        myScale = myDoc.StretchMax - myDoc.StretchMin
        If myScale < 100 Then myScale = 100
        If myScale > 32000 Then myScale = 32000
    Else
        myMin = Img.Background
        myScale = Img.Range
    End If
   
    'frmImage.Picture1.ScaleMode = 3   ' Set ScaleMode to pixels.
    errMsg = "Set Picture1 properties."
    'frmImage.Caption = "Screen size: w=" & W / i & "; h=" & H / j & "   picture width: " & (imgWidth / previewScale) & "; image height: " & (imgHeight / previewScale)
    If (imgWidth / previewScale) > (W - 100) Or (imgHeight / previewScale) > (H - 100) Then
        previewScale = previewScale + 1
        frmImage.Combo1.ListIndex = previewScale - 1
        SaveSetting "NewAstro Gradient Removal", "resume", "previewScale", CStr(previewScale)
    End If
    frmImage.Picture1.Width = imgWidth / previewScale
    frmImage.Picture1.Height = imgHeight / previewScale
    If frmImage.optLinear Then
        frmImage.pctDot(0).Left = frmImage.Picture1.Left
        frmImage.pctDot(0).Top = frmImage.Picture1.Top + CInt(frmImage.Picture1.Height / 2)
    Else
        frmImage.pctDot(0).Left = frmImage.Picture1.Left + (frmImage.Picture1.Width / 2) - (frmImage.pctDot(1).ScaleWidth / 2)
        frmImage.pctDot(0).Top = frmImage.Picture1.Top + (frmImage.Picture1.Height / 2) - (frmImage.pctDot(1).ScaleHeight / 2)
    End If
    frmImage.pctDot(1).Left = frmImage.Picture1.Left + frmImage.Picture1.Width - frmImage.pctDot(1).Width
    frmImage.pctDot(1).Top = frmImage.Picture1.Top + CInt(frmImage.Picture1.Height / 2)
    If frmImage.Picture1.Width * 15 + 250 < 5370 Then
        frmImage.Width = 5370
    Else
        frmImage.Width = frmImage.Picture1.Width * 15 + 250
    End If
    errMsg = "Set frmImage properties."
    frmImage.Height = frmImage.Picture1.Height * 15 + 1280
    frmImage.cmdDone.Top = frmImage.Picture1.Height + 15
    frmImage.cmdCancel.Top = frmImage.Picture1.Height + 15
    frmImage.lblMsg.Top = frmImage.Picture1.Height + 15
    frmImage.optLinear.Top = frmImage.cmdDone.Top + 20
    frmImage.optRadial.Top = frmImage.cmdDone.Top + 20
    frmImage.lblSize.Top = frmImage.cmdDone.Top + 20
    frmImage.Combo1.Top = frmImage.optLinear.Top - 4
    frmImage.Picture1.DrawWidth = 1 ' Set DrawWidth.
    frmImage.Picture1.Cls   ' Clear form.
    frmImage.Picture1.Visible = False
    errMsg = "Painting picture."
    frmImage.lblMsg.ForeColor = vbRed
    For X = 0 To imgWidth - 1 Step previewScale
        If abortPaintImage Then
            'Exit Sub
        End If
        errMsg = "Painting picture - x=" & X
        For Y = 0 To imgHeight - 1 Step previewScale
            If Y > 200 Then
                frmImage.Picture1.Visible = False
            End If
            errMsg = "Painting picture - x=" & X & "; y=" & Y
            ' Paint picture box.
            n = Round(((myImgArray(X, Y) - myMin) / myScale) * 256)
            errMsg = "Color value is " & n
            If n < 0 Then n = 0
            If n > 256 Then n = 256
            frmImage.Picture1.PSet (X / previewScale, Y / previewScale), RGB(n, n, n)
            DoEvents
        Next Y
        If X Mod Round((imgWidth / previewScale) / 10) = 0 Then
            errMsg = "Making image visible."
            frmImage.Picture1.Visible = True
            frmImage.Refresh
        End If
        frmImage.Caption = "Loading image..." & Round((X / imgWidth) * 100) & "%"
        frmImage.lblMsg.Caption = "Loading image..." & Round((X / imgWidth) * 100) & "%"
    Next X
    frmImage.lblMsg.ForeColor = vbBlack
    errMsg = "Setting pctDot properties"
    frmImage.pctDot(0).Visible = True
    frmImage.pctDot(1).Visible = True
    errMsg = "Making image visible."
    frmImage.Picture1.Visible = True
    frmImage.Caption = "Mark Gradient"
    frmImage.lblMsg.Caption = ""
    On Error GoTo 0
    frmImage.cmdCancel.Enabled = True
    frmImage.cmdDone.Enabled = True
    Exit Sub
    
errHandler:
    errMsg = "Error painting bloomed pixels #" & Err.Number & ": " & Err.Description & vbCrLf & "Additional information: " & errMsg
    MsgBox errMsg
    Exit Sub
End Sub

