VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "colorFlatPlugIn"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
' Newastro Make JPG Camera Event Plug-in for CCDSoft.
' Copyright 2003 by Ron Wodaski
' All rights reserved.
' Source code may be used with permission to learn how to write
'   camera event plug-ins for CCDSoft.

Option Explicit

' See module moduleEvent.bas for constants and other stuff.

' To read/set properties or invoke methods from a script:
'Dim objMakeJPG
'Set objMakeJPG = CreateObject("NewastroMakeJPG.ImgProc")
'objMakeJPG.Active = 1

Property Get Name() As String
    Name = "Color flat normalizer " & App.Major & "." & App.Minor & "." & App.Revision
End Property

Property Get WantEvent(WhichEvent As Long) As Long
    Dim MyVal As Long
    If (WhichEvent = CamAfterDisplayImage) Then
        WantEvent = 1
    Else
        WantEvent = 0
    End If
End Property

Private Function fixBooleanInput(inputValue)
    If inputValue <> 0 Then
        fixBooleanInput = 1
    Else
        fixBooleanInput = 0
    End If
End Function

Public Sub CameraEvent(WhichEvent As Long, WhichCamera As Long, MyString As String, Param1 As Long, Param2 As Long)

    Dim Cam
    Dim myPrivateArray
    Dim mySavePath, mySavePathRef, mySaveLatest, myPath
    Dim fs, OK2Process As Boolean
    
    On Error GoTo errHandler
    
    If WhichEvent = CamAfterDisplayImage Then
        errMsg = "Entering CamAfterDisplayImage event handler functional code."
        'MsgBox "After exposure."
        SaveSetting "NewAstro CCDSoft Event Handlers", "makeJPG", "exposureComplete", "True"
        DoEvents
        ' ===================================================================================================
        ' Begin validation checks. Must include every case that could cause trouble!
        ' ===================================================================================================
        
        ' Make sure that we have a path to save to.
        errMsg = "Creating image object."
        Set Img = CreateObject("CCDSoft.Image")
        errMsg = "Attaching to active image."
        Img.AttachToActiveImager
        OK2Process = False
        If Len(Img.Path) <> 0 Then
            OK2Process = True
        End If
        
        'Make sure this event is for a flat frame; don't want to normalize bias/dark/light.
        errMsg = "Creating camera object."
        Set Cam = CreateObject("CCDSoft.Camera")
        errMsg = "Checking frame type."
        If (Cam.Frame = 1 Or Cam.Frame = 4) Then
            OK2Process = True
        End If
        
        ' Make sure autosave is on.
        errMsg = "Verifying that Auto save is enabled."
        If Cam.AutoSaveOn = 1 Then
            OK2Process = True
        End If
        Set Cam = Nothing
        ' ===================================================================================================
        ' End validation checks.
        ' ===================================================================================================
        
        If OK2Process Then
        ' Copy the image.
        errMsg = "Creating newImg object."
        Set newImg = CreateObject("CCDSoft.Image")
        errMsg = "'New' method, with width=" & Img.Width & ", height=" & Img.Height
        newImg.Visible = False
        newImg.New Img.Width, Img.Height, 16
        ' Copying path to new image. Be careful not to simply overwrite the original image file
        errMsg = "Copying path to newImg."
        newImg.Path = Img.Path
        ' Copy the data into an array for anything you plan to do to it.
        errMsg = "Storing Img data into local array."
        myPrivateArray = Img.DataArray
        ' ===================================================================================================
        ' Normalize the color data.
        ' Calculate normalization factors.
        Dim pixelTotal(5) As Long
        Dim pixelAvg(5) As Long
        Dim pixelFactor(5)
        Dim i, j, maxX, maxY, numGrids, originX, originY, referenceAvg
        
        ' Initialize total array.
        For i = 1 To 4
            pixelTotal(i) = 0
        Next i
        ' Normalize using a simple average based on 10 2x2 grids.
        errMsg = "Get number of grids."
        numGrids = CInt(GetSetting("NewAstro CCDSoft Event Handlers", "colorFlatNorm", "txtNumGrids", "10"))
        errMsg = "Getting X and Y coordinates for top left of sample grids."
        originX = CLng(GetSetting("NewAstro CCDSoft Event Handlers", "colorFlatNorm", "txtOriginX", "100"))
        originY = CLng(GetSetting("NewAstro CCDSoft Event Handlers", "colorFlatNorm", "txtOriginY", "100"))
        errMsg = "Looking at " & numGrids & " 2x2 squares to get averaged values."
        For i = 0 To (numGrids * 2 - 2) Step 2
            pixelTotal(1) = pixelTotal(1) + myPrivateArray(originX + i, originY + i)
            pixelTotal(2) = pixelTotal(2) + myPrivateArray(originX + 1 + i, originY + i)
            pixelTotal(3) = pixelTotal(3) + myPrivateArray(originX + i, originY + 1 + i)
            pixelTotal(4) = pixelTotal(4) + myPrivateArray(originX + 1 + i, originY + 1 + i)
        Next i
        errMsg = "Calculating averages."
        For i = 1 To 4
            pixelAvg(i) = pixelTotal(i) / 10
        Next i
        AvgLimit = CLng(GetSetting("NewAstro CCDSoft Event Handlers", "colorFlatNorm", "txtAvgLimit", "50000"))
        If pixelAvg(1) > AvgLimit Then
            Err.Raise ERR_PIXEL_SATURATED, "ColorFlat", "The upper left pixel average in the sample grid is too bright - cannot normalize."
            OK2Process = False
        End If
        If pixelAvg(2) > AvgLimit Then
            Err.Raise ERR_PIXEL_SATURATED, "ColorFlat", "The upper right pixel average in the sample grid is too bright - cannot normalize."
            OK2Process = False
        End If
        If pixelAvg(3) > AvgLimit Then
            Err.Raise ERR_PIXEL_SATURATED, "ColorFlat", "The lower left pixel average in the sample grid is too bright - cannot normalize."
            OK2Process = False
        End If
        If pixelAvg(4) > AvgLimit Then
            Err.Raise ERR_PIXEL_SATURATED, "ColorFlat", "The lower right pixel average in the sample grid is too bright - cannot normalize."
            OK2Process = False
        End If
        If pixelAvg(1) <= 0 Or pixelAvg(2) <= 0 Or pixelAvg(3) <= 0 Or pixelAvg(4) <= 0 Then
            errMsg = "Invalid average(s) - zero or less."
            For i = 1 To 4
                pixelFactor(i) = 1#
            Next i
            'OK2Process = False
            'MsgBox "Not OK to process."
            errMsg = "One or more zero values for pixel averages."
        Else
            errMsg = "Calculating factors."
            referenceAvg = CInt(GetSetting("NewAstro CCDSoft Event Handlers", "colorFlatNorm", "cmbRefAvg", "2"))
            For i = 1 To 4
                If i = referenceAvg Then
                    pixelFactor(i) = 1#
                Else
                    pixelFactor(i) = pixelFactor(i) / pixelFactor(referenceAvg)
                End If
            Next i
            'MsgBox "OK to process."
            errMsg = "No zero values for pixel averages."
        End If
        If OK2Process Then
        ' ===================================================================================================
        ' Perform normalization.
        errMsg = "Get array bounds: first."
        maxX = UBound(myPrivateArray, 1)
        'MsgBox maxX
        errMsg = "Get array bounds: second."
        maxY = UBound(myPrivateArray, 2)
        errMsg = "Normalzing..."
        For i = 0 To maxX Step 2
            For j = 0 To maxY Step 2
                errMsg = "Normalizing row " & i
                myPrivateArray(i, j) = myPrivateArray(i, j) / pixelFactor(1)
                myPrivateArray(i + 1, j) = myPrivateArray(i + 1, j) / pixelFactor(2)
                myPrivateArray(i, j + 1) = myPrivateArray(i, j + 1) / pixelFactor(3)
                myPrivateArray(i + 1, j + 1) = myPrivateArray(i + 1, j + 1) / pixelFactor(4)
            Next j
        Next i
        ' ===================================================================================================
        ' Passing results of processing (array contents) to the new image.
        errMsg = "Copying local array to newImg."
        newImg.DataArray = myPrivateArray
        ' Set image contrast (otherwise will be all white when the JPG is saved. Experiement to see what contrast
        '   settings work best for your situation. The contrast settings would need to be user-settable in a
        '   real situation.
        errMsg = "Set auto contrast."
        newImg.AutoContrast 2, 1, 3
        ' Save normalized image.
        ' myOriginalPath = newImg.Path
        newImg.Path = Left(Img.Path, Len(Img.Path) - 4) & "_NORM.FIT"
        errMsg = "Save normalized file."
        newImg.Save
        ' newImg.Path = myOriginalPath
        
        ' Release the Img object.
        newImg.DetachOnClose = 0
        newImg.Close
        End If
        End If
        Set Img = Nothing
        Set newImg = Nothing
        If Not OK2Process Then
            Err.Raise 1, "colorFlat", "Unable to process."
        End If
        
    End If
    
    Set Img = Nothing
    On Error GoTo 0
    
    Exit Sub
errHandler:
    Err.Raise Err.Number, "colorFlat", Err.Description & vbCrLf & "Context: " & errMsg
    Exit Sub
End Sub

Public Sub Settings()
    frmSetupOptions.Show 1
End Sub

